package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author Gyf
 *         相同APP 相同ITEM 相同CREDITS 累计兑换超过5次，第六次拦截，持续一天
 */
@Component
public class AnticheatSameCreditsAddUpStrategy implements AnticheatStrategy {

    /**
     * key itemId + "-" + appId + "-" + credits
     * value
     */
    private static Map<String, Integer> couponExchangeMap = new ConcurrentHashMap<>();

    public static void clearMap() {
        couponExchangeMap.clear();
    }

    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS_ADD_UP).getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS_ADD_UP).getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS_ADD_UP).getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService
                .getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS_ADD_UP);
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Long appId = consumer.getAppId();
        Long credits = consumer.getCredits();

        Integer gtype = goods.getGtype();
        Long gid = goods.getGid();

        Integer value = couponExchangeMap.get(getItemAppCreditsKey(gtype, gid, appId, credits));
        if (value == null) {
            value = 1;
            couponExchangeMap.put(getItemAppCreditsKey(gtype, gid, appId, credits), value);
        } else {
            couponExchangeMap.put(getItemAppCreditsKey(gtype, gid, appId, credits), ++value);
        }
        if (value > 5) {
            Long debugId = doMatchProcess(consumer, goods, request);
            return new AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_SAME_CREDITS_ADD_UP);
        debug.setMessage(String.format("相同 appId: %s, gtype: %s, gid: %s, credits: %s, 累计兑换超过5次", consumer.getAppId(), goods.getGtype(), goods.getGid(), consumer.getCredits()));

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }

    private String getItemAppCreditsKey(Integer gtype, Long gid, Long appId, Long credits) {
        return String.format("%s-%s-%s-%s", gtype, gid, appId, credits);
    }
}
