package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Objects;

/**
 * 手势为空，使用电脑刷券
 */
@Component
public class AnticheatSwipeSkipStrategy implements AnticheatStrategy {

    // 手势不存在
    public static final Integer SWIPE_NOT_EXIST = 0;
    // 手势存在
    public static final Integer SWIPE_EXIST = 1;
    // 验证出错
    public static final Integer SWIPE_ERROR = 2;
    // 不需要验证手势
    public static final Integer SWIPE_SKIP = 3;

    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    @Override
    public boolean isEnable() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SWIPE_SKIP).getEnable();
    }

    @Override
    public int getCheckMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SWIPE_SKIP).getCheckMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public int getEffectMode() {
        return anticheatStrategyConfigService.getCacheConfig(AnticheatStrategyConfigEntity.TYPE_SWIPE_SKIP).getEffectMode();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = anticheatStrategyConfigService.getCacheAppConfig(AnticheatStrategyConfigEntity.TYPE_SWIPE_SKIP);
        return map.containsKey(appId);
    }

    @Override
    public AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Integer swipe = behavior.getSwipe();
        if (Objects.equals(SWIPE_SKIP, swipe)) {
            Long debugId = doMatchProcess(consumer, goods, request);
            return new AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType(AnticheatStrategyConfigEntity.TYPE_SWIPE_SKIP);
        debug.setMessage("手势为空(非iphone, ipad, android)，不需要验证手势");

        anticheatDebugLogDao.insert(debug);

        return debug.getId();
    }

}
