package cn.com.duiba.apollo.portal.biz;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * @author liuyao
 */
@Data
@ConfigurationProperties(prefix = "duiba.apollo")
public class ApolloProperties implements Serializable {

    private String eventTopic = "apollo-event-topic";

    private Set<Long> superManagers = Sets.newHashSet();

    /**
     * 阿波罗资源化实例申请钉钉审批通知人(暂时默认 邵兵和李文刚)
     */
    private List<Long> resInstanceApproveSuperManager = Lists.newArrayList(46L, 4043L);

}
