package cn.com.duiba.apollo.portal.biz.domain;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Objects;

/**
 * @author liuyao
 */
@Data
public class ReleaseKey{

    @NotBlank
    private String appId;
    @NotBlank
    private String namespaceName;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReleaseKey)) {
            return false;
        }
        ReleaseKey that = (ReleaseKey) o;
        return Objects.equals(appId, that.appId) &&
                Objects.equals(namespaceName, that.namespaceName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, namespaceName);
    }

    @Override
    public String toString() {
        return "ReleaseKey{" +
                "appId='" + appId + '\'' +
                ", namespaceName='" + namespaceName + '\'' +
                '}';
    }
}
