package cn.com.duiba.apollo.portal.biz.jpa.apollo.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@Table(name = "AccessKey")
@SQLDelete(sql = "Update AccessKey set isDeleted = 1 where id = ?")
@Where(clause = "isDeleted = 0")
public class AccessKey extends BaseEntity {

  @Column(name = "appId", nullable = false)
  private String appId;

  @Column(name = "Cluster", nullable = false)
  private String cluster;

  @Column(name = "Secret", nullable = false)
  private String secret;

  @Column(name = "isEnabled", columnDefinition = "Bit default '0'")
  private boolean enabled;

  private String adminName;

  @Override
  public String toString() {
    return toStringHelper().add("appId", appId).add("secret", secret)
        .add("enabled", enabled).toString();
  }
}
