package cn.com.duiba.apollo.portal.biz.jpa.apollo.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;

/**
 * @author liuyao
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@Table(name = "Item")
@SQLDelete(sql = "Update Item set isDeleted = 1 where id = ?")
@Where(clause = "isDeleted = 0")
public class Item extends BaseEntity {

  @Column(name = "NamespaceId", nullable = false)
  private long namespaceId;

  @Column(name = "Key", nullable = false)
  private String key;

  @Column(name = "Value")
  @Lob
  private String value;

  @Column(name = "Comment")
  private String comment;

  @Column(name = "LineNum")
  private Integer lineNum;

  private String oldValue;

  @Override
  public String toString() {
    return toStringHelper().add("namespaceId", namespaceId).add("key", key).add("value", value)
        .add("lineNum", lineNum).add("comment", comment).toString();
  }
}
