package cn.com.duiba.apollo.portal.biz.jpa.apollo.entity;

import cn.com.duiba.apollo.portal.biz.service.StringUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author liuyao
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@Table(name = "Namespace")
@SQLDelete(sql = "Update Namespace set isDeleted = 1 where id = ?")
@Where(clause = "isDeleted = 0")
public class Namespace extends BaseEntity {

  @Column(name = "AppId", nullable = false)
  private String appId;

  @Column(name = "ClusterName", nullable = false)
  private String clusterName;

  @Column(name = "NamespaceName", nullable = false)
  private String namespaceName;

  @Column(name = "ParentAppId")
  private String parentAppId;

  public boolean isInvalid() {
    return StringUtils.isContainEmpty(appId, clusterName, namespaceName);
  }

  @Override
  public String toString() {
    return "Namespace{" +
            "appId='" + appId + '\'' +
            ", clusterName='" + clusterName + '\'' +
            ", namespaceName='" + namespaceName + '\'' +
            '}';
  }
}
