package cn.com.duiba.apollo.portal.biz.jpa.resource.entity;

import cn.com.duiba.apollo.portal.biz.constants.RequisitionType;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;

@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@Table(name = "Requisition")
public class Requisition extends BaseEntity {

    @Column(name = "Applicant")
    private Long applicant;
    @Column(name = "Operation")
    private String operation;
    @Column(name = "BizId")
    private Long bizId;
    @Column(name = "Auditor")
    private Long auditor;
    @Column(name = "Status")
    private String status;
    @Lob
    @Column(name = "Parameter")
    private String parameter;
    @Column(name = "Remarks")
    private String remarks;

    public void setRequisitionType(RequisitionType requisitionType) {
        this.operation = requisitionType.getName();
    }

}
