package cn.com.duiba.apollo.portal.biz.jpa.resource.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 描述: 实例副本表
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/10/26 10:32
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "tb_resource_instance_transcript")
public class ResourceInstanceTranscript extends BaseEntity {

    @Column(name = "TranscriptName", nullable = false)
    private String transcriptName;
    @Column(name = "InstanceId", nullable = false)
    private Long instanceId;
    @Column(name = "Operator", nullable = false)
    private Long operator;
    @Column(name = "Description")
    private String description;

    /**
     * 主从关系 0-主 1-从 (主要为了解决rpc接口的兼容问题：当查询接口只存在instanceId的时候，查询主副本)
     */
    @Column(name = "LevelStatus")
    private Integer levelStatus;

}
