package cn.com.duiba.apollo.portal.biz.jpa.resource.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@Table(name = "ResourceReferenceRelease")
public class ResourceReferenceRelease extends BaseEntity {

    @Column(name = "ReferenceId", nullable = false)
    private Long referenceId;
    @Column(name = "Name", nullable = false)
    private String name;
    @Column(name = "Operator", nullable = false)
    private Long operator;
    @Column(name = "Configurations", nullable = false)
    @Lob
    private String configurations;
    @Column(name = "InstanceConfigurations", nullable = false)
    @Lob
    private String instanceConfigurations;
    @Column(name = "Abandoned", columnDefinition = "Bit default '0'")
    private boolean abandoned = false;
    @Column(name = "ReleaseKey", nullable = false)
    private String releaseKey;
    @Column(name = "Comment", nullable = false)
    private String comment;

    public ResourceReferenceRelease(){}

    public ResourceReferenceRelease(Long id, Long referenceId, Long operator, String comment, Date gmtCreate){
        this.setId(id);
        this.referenceId = referenceId;
        this.operator = operator;
        this.comment = comment;
        this.setGmtCreate(gmtCreate);
    }


}
