package cn.com.duiba.apollo.portal.biz.jpa.resource.repository;

import cn.com.duiba.apollo.portal.biz.jpa.resource.entity.ResourceInstanceItem;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 * @author liuyao
 */
public interface ResourceInstanceItemRepository extends JpaRepository<ResourceInstanceItem,Long> {

    @Modifying
    void deleteAllByTypeKeyAndFieldKey(String type,String key);
    @Modifying
    void deleteAllByInstanceId(Long instanceId);

    List<ResourceInstanceItem> findAllByInstanceId(Long instanceId);

    List<ResourceInstanceItem> findAllByTypeKeyAndFieldKeyInAndValueLike(String type,List<String> fieldKeys,String key);

    @Query("SELECT distinct instanceId from ResourceInstanceItem where typeKey = :type and FieldKey in :fieldKeys and value like concat('%',:key,'%')")
    List<Long> findDistinctInstanceIdByTypeKeyAndFieldKeyInAndValueLike(@Param("type") String type,@Param("fieldKeys") List<String> fieldKeys, @Param("key") String key);

    List<ResourceInstanceItem> findAllByTranscriptId(Long transcriptId);

    @Modifying
    void deleteAllByInstanceIdAndTranscriptId(Long instanceId, Long transcriptId);


}
