package cn.com.duiba.apollo.portal.biz.jpa.resource.repository;

import cn.com.duiba.apollo.portal.biz.jpa.resource.entity.ResourceInstanceReference;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * cluster和instanceId相对于ResourceInstance构成传递依赖
 * 主要是方便findAllByClusterAndUserIdAndBizId()的查询，防止加载一个集群下的引用时，还要根据ResourceInstance中的集群变量做过滤
 */
public interface ResourceInstanceReferenceRepository extends JpaRepository<ResourceInstanceReference,Long>,JpaSpecificationExecutor<ResourceInstanceReference> {

    ResourceInstanceReference findFristById(Long id);

    List<ResourceInstanceReference> findAllByClusterAndUserIdAndBizId(String cluster, Long userId, String bizId);

    List<ResourceInstanceReference> findAllByTranscriptIdAndActiveIsTrue(Long transcriptId);

    List<ResourceInstanceReference> findAllByInstanceId(Long instanceId);

    ResourceInstanceReference findByTranscriptIdAndUserIdAndBizId(Long transcriptId,Long userId, String bizId);

    List<ResourceInstanceReference> findAllByTemplateIdAndClusterAndActiveIsTrue(Long templateId,String cluster);

    int countAllByInstanceId(Long instanceId);

    int countAllByInstanceIdAndUserId(Long instanceId,Long userId);

    List<ResourceInstanceReference> findAllByInstanceIdAndTranscriptId(Long instanceId, Long transcriptId);


}
