package cn.com.duiba.apollo.portal.biz.jpa.resource.repository;

import cn.com.duiba.apollo.portal.biz.jpa.resource.entity.ResourceInstance;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface ResourceInstanceRepository extends JpaRepository<ResourceInstance,Long>, JpaSpecificationExecutor<ResourceInstance> {

    @Query("select id from ResourceInstance where cluster = :cluster and type = :type")
    List<Long> findAllIdByClusterAndType(@Param("cluster")String cluster,@Param("type") String type);

    ResourceInstance findByClusterAndTypeAndKey(String cluster,String typeId,String key);

    ResourceInstance findFirstByClusterAndId(String cluster,Long id);

    List<ResourceInstance> findByClusterAndTypeAndKeyIn(String cluster, String type, List<String> keyList);

    List<ResourceInstance> findAllByClusterAndType(@Param("cluster")String cluster,@Param("type") String type);


}

