package cn.com.duiba.apollo.portal.biz.jpa.resource.repository;

import cn.com.duiba.apollo.portal.biz.jpa.resource.entity.ResourceInstanceTranscript;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.List;

/**
 * 描述: 实例副本repository
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2021/10/26 10:32
 */
public interface ResourceInstanceTranscriptRepository extends JpaRepository<ResourceInstanceTranscript, Long>, JpaSpecificationExecutor<ResourceInstanceTranscript> {

    List<ResourceInstanceTranscript> findByInstanceId(Long instanceId);

    int countByInstanceId(Long instanceId);

    /**
     * 为了rpc接口兼容而设计的接口，一般情况请勿使用
     *
     * @param instanceId
     * @param level
     * @return
     */
    @Deprecated
    ResourceInstanceTranscript findFirstByInstanceIdAndLevelStatus(Long instanceId, Integer level);

    List<ResourceInstanceTranscript> findByIdIn(List<Long> transcriptIdList);


}

