package cn.com.duiba.apollo.portal.biz.jpa.resource.repository;

import cn.com.duiba.apollo.portal.biz.jpa.resource.entity.ResourceReferenceRelease;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface ResourceReferenceReleaseRepository extends JpaRepository<ResourceReferenceRelease,Long> {

    List<ResourceReferenceRelease> findAllByReferenceId(Long referenceId);

    ResourceReferenceRelease findByReferenceIdAndAbandonedIsFalse(Long referenceId);

    @Modifying
    @Query("update ResourceReferenceRelease set abandoned = true where referenceId = :referenceId and abandoned = false")
    void updateAbandonedToTrue(@Param("referenceId") Long referenceId);


}
