package cn.com.duiba.apollo.portal.biz.service;

import cn.com.duiba.apollo.portal.biz.domain.AppConfigKey;
import cn.com.duiba.apollo.portal.biz.jpa.apollo.entity.AppConfig;
import cn.com.duiba.apollo.portal.biz.jpa.apollo.repository.AppConfigRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Objects;
import java.util.Optional;

/**
 * @author liuyao
 */
@Service
public class AppConfigService {

    @Resource
    private AppConfigRepository appConfigRepository;

    @Transactional
    public void config(AppConfig params){
        AppConfig appConfig = appConfigRepository.findByClusterAndAppIdAndKey(params.getCluster(),params.getAppId(),params.getKey());
        Objects.requireNonNull(params.getDataChangeLastModifiedBy());

        if(Objects.isNull(appConfig)){
            params.setDataChangeCreatedBy(params.getDataChangeLastModifiedBy());
            appConfigRepository.save(params);
        }else{
            appConfig.setDataChangeLastModifiedBy(params.getDataChangeLastModifiedBy());
            appConfig.setValue(params.getValue());
            appConfigRepository.save(appConfig);
        }
    }

    public Boolean getBoolean(AppConfigKey key){
        return Boolean.valueOf(getString(key));
    }

    public String getString(AppConfigKey key){
        AppConfig appConfig = appConfigRepository.findByClusterAndAppIdAndKey(key.getCluster(),key.getAppId(),key.getKey());
        return Optional.ofNullable(appConfig).map(AppConfig::getValue).orElse("");
    }

}
