package cn.com.duiba.apollo.portal.biz.service;

import cn.com.duiba.apollo.portal.biz.domain.AppConfigKey;
import cn.com.duiba.apollo.portal.biz.jpa.apollo.entity.AppConfig;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.commons.lang.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * @author liuyao
 */
public class AppSecretService {

    @Resource
    private AppConfigService appConfigService;

    private String cluster;

    private final LoadingCache<String,String> appSecretCache = Caffeine.newBuilder().expireAfterAccess(1, TimeUnit.MINUTES).build(new CacheLoader<String, String>() {
        @Override
        public @Nullable String load(@NonNull String appId) {
            AppConfigKey configKey = buildAppConfigKey(appId);
            return appConfigService.getString(configKey);
        }
    });

    public void createAppSecret(String appId,String appSecret,Long adminId){
        AppConfigKey configKey = buildAppConfigKey(appId);
        String hasAppSecret = appConfigService.getString(configKey);
        if(StringUtils.isNotBlank(hasAppSecret)){
            return;
        }
        AppConfig params = new AppConfig();
        params.setAppId(appId);
        params.setKey(AppConfig.APP_SECRET);
        params.setValue(appSecret);
        params.setDataChangeLastModifiedBy(adminId);
        params.setCluster(cluster);
        appConfigService.config(params);
    }

    public String getAppSecret(String appId){
        String appSecret = appSecretCache.get(appId);
        if(StringUtils.isBlank(appSecret)){
            appSecretCache.invalidate(appId);
        }
        return appSecret;
    }

    private AppConfigKey buildAppConfigKey(String appId){
        AppConfigKey configKey = new AppConfigKey();
        configKey.setAppId(appId);
        configKey.setKey(AppConfig.APP_SECRET);
        //应用秘钥每个环境共用一个
        configKey.setCluster(cluster);
        return configKey;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }
}
