/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.portal.biz.service;

import cn.com.duiba.apollo.portal.biz.domain.AppConfigKey;
import cn.com.duiba.apollo.portal.biz.jpa.apollo.entity.AppConfig;
import cn.com.duiba.apollo.portal.biz.jpa.apollo.repository.AppConfigRepository;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppConfigService {
    @Resource
    private AppConfigRepository appConfigRepository;

    @Transactional
    public void config(AppConfig params) {
        AppConfig appConfig = this.appConfigRepository.findByClusterAndAppIdAndKey(params.getCluster(), params.getAppId(), params.getKey());
        Objects.requireNonNull(params.getDataChangeLastModifiedBy());
        if (Objects.isNull(appConfig)) {
            params.setDataChangeCreatedBy(params.getDataChangeLastModifiedBy());
            this.appConfigRepository.save(params);
        } else {
            appConfig.setDataChangeLastModifiedBy(params.getDataChangeLastModifiedBy());
            appConfig.setValue(params.getValue());
            this.appConfigRepository.save(appConfig);
        }
    }

    public Boolean getBoolean(AppConfigKey key) {
        return Boolean.valueOf(this.getString(key));
    }

    public String getString(AppConfigKey key) {
        AppConfig appConfig = this.appConfigRepository.findByClusterAndAppIdAndKey(key.getCluster(), key.getAppId(), key.getKey());
        return Optional.ofNullable(appConfig).map(AppConfig::getValue).orElse("");
    }
}

