CREATE TABLE `namespace` (
  `Id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增主键',
  `AppId` varchar(500) NOT NULL DEFAULT 'default' COMMENT 'AppID',
  `ClusterName` varchar(500) NOT NULL DEFAULT 'default' COMMENT 'Cluster Name',
  `NamespaceName` varchar(500) NOT NULL DEFAULT 'default' COMMENT 'Namespace Name',
  `ParentAppId` bigint(20) COMMENT '关联的Namespace所在的app',
  `IsDeleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '1: deleted, 0: normal',
  `DataChange_CreatedBy` bigint(10) NOT NULL DEFAULT '1' COMMENT '创建人Id',
  `DataChange_CreatedTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `DataChange_LastModifiedBy` bigint(10) NOT NULL DEFAULT '1' COMMENT '最后修改人Id',
  `DataChange_LastTime` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  KEY `AppId_ClusterName_NamespaceName` (`AppId`(191),`ClusterName`(191),`NamespaceName`(191)),
  KEY `DataChange_LastTime` (`DataChange_LastTime`),
  KEY `IX_NamespaceName` (`NamespaceName`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2383 DEFAULT CHARSET=utf8mb4 COMMENT='命名空间'


CREATE TABLE `AppConfig`
(
  `Id`                        int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增主键',
  `AppId`                     varchar(32)      NOT NULL DEFAULT '' COMMENT 'app id',
  `Cluster`                   varchar(32)      NOT NULL DEFAULT 'default' COMMENT '配置对应的集群',
  `Key`                       varchar(64)      NOT NULL DEFAULT 'default' COMMENT '配置项Key',
  `Value`                     varchar(2048)    NOT NULL DEFAULT 'default' COMMENT '配置项值',
  `DataChange_CreatedBy`      bigint unsigned  NOT NULL COMMENT '创建人',
  `DataChange_CreatedTime`    timestamp        NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `DataChange_LastModifiedBy` bigint unsigned  NOT NULL COMMENT '最后修改人',
  `DataChange_LastTime`       timestamp        NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  KEY `IX_AppId` (`AppId`),
  UNIQUE KEY `AppId_Key` (`Cluster`, `AppId`, `Key`),
  KEY `DataChange_LastTime` (`DataChange_LastTime`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='应用配置';


CREATE TABLE `NamespaceEditLock`
(
  `Id`          int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `NamespaceId` bigint UNSIGNED  NOT NULL COMMENT '集群NamespaceId',
  `LockType`    varchar(32)      NOT NULL DEFAULT 'namespace' COMMENT '锁类型',
  `LockOwner`   bigint unsigned  NOT NULL COMMENT '发起锁的人',
  `GmtCreate`   timestamp        NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp        NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`) USING BTREE,
  UNIQUE INDEX `IX_NamespaceId` (`LockType`, `NamespaceId`) USING BTREE,
  INDEX `GmtModified` (`GmtModified`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_general_ci COMMENT = 'namespace的编辑锁';


CREATE TABLE `Requisition`
(
  `Id`          bigint UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '自增id',
  `Applicant`   bigint UNSIGNED NOT NULL COMMENT '申请人',
  `Operation`   varchar(32)     NOT NULL COMMENT '申请类型',
  `BizId`       bigint UNSIGNED NOT NULL COMMENT '关联实体的id',
  `Auditor`     bigint UNSIGNED COMMENT '指定的审核人或最终审核人',
  `Status`      varchar(32)     NOT NULL COMMENT '审核状态',
  `Parameter`   longtext        NOT NULL COMMENT '附加参数',
  `Remarks`     varchar(512) COMMENT '备注',
  `GmtCreate`   timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `GmtModified` timestamp       NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`) USING BTREE,
  INDEX `IX_Requisition_Statue` (`Operation`, `BizId`, `Status`) USING BTREE,
  INDEX `GmtModified` (`GmtModified`) USING BTREE
) ENGINE = InnoDB
  AUTO_INCREMENT = 1
  CHARACTER SET = utf8mb4
  COLLATE = utf8mb4_general_ci COMMENT = '请求单';

CREATE TABLE `AccessKey`
(
  `Id`                        int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增主键',
  `AppId`                     varchar(500)     NOT NULL DEFAULT 'default' COMMENT 'AppID',
  `Secret`                    varchar(128)     NOT NULL DEFAULT '' COMMENT 'Secret',
  `Cluster`                   varchar(32)      NOT NULL DEFAULT 'default' COMMENT '配置对应的集群',
  `IsEnabled`                 bit(1)           NOT NULL DEFAULT b'0' COMMENT '1: enabled, 0: disabled',
  `IsDeleted`                 bit(1)           NOT NULL DEFAULT b'0' COMMENT '1: deleted, 0: normal',
  `DataChange_CreatedBy`      varchar(32)      NOT NULL DEFAULT 'default' COMMENT '创建人邮箱前缀',
  `DataChange_CreatedTime`    timestamp        NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `DataChange_LastModifiedBy` varchar(32)      NOT NULL DEFAULT '' COMMENT '最后修改人邮箱前缀',
  `DataChange_LastTime`       timestamp        NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '最后修改时间',
  PRIMARY KEY (`Id`),
  KEY `AppId` (`Cluster`,`AppId`(191)),
  KEY `DataChange_LastTime` (`DataChange_LastTime`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='访问密钥';