/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.center.api.constants;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum ConfigFileFormat {
    Properties("properties"),
    XML("xml"),
    JSON("json"),
    YML("yml"),
    YAML("yaml");

    private static final Map<String, ConfigFileFormat> SUPPORT_FORMATS;
    private final String value;

    private ConfigFileFormat(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static String clearFormat(String namespaceName) {
        if (StringUtils.isBlank((CharSequence)namespaceName)) {
            return namespaceName;
        }
        String format = ConfigFileFormat.analyFormat(namespaceName);
        if (StringUtils.isBlank((CharSequence)format)) {
            return namespaceName;
        }
        return namespaceName.substring(0, format.length());
    }

    public static String analyFormat(String namespaceName) {
        if (StringUtils.isEmpty((CharSequence)namespaceName)) {
            return "";
        }
        int lastIndex = namespaceName.lastIndexOf(".");
        if (lastIndex == -1) {
            return "";
        }
        if (StringUtils.endsWith((CharSequence)namespaceName, (CharSequence)".")) {
            return "";
        }
        String format = namespaceName.substring(lastIndex + 1);
        if (!SUPPORT_FORMATS.containsKey(format)) {
            return "";
        }
        return format;
    }

    public static ConfigFileFormat fromString(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException("value can not be empty");
        }
        ConfigFileFormat format = SUPPORT_FORMATS.get(value);
        if (Objects.nonNull((Object)format)) {
            return format;
        }
        throw new IllegalArgumentException(value + " can not map format enum");
    }

    public static boolean isValidFormat(String value) {
        try {
            ConfigFileFormat.fromString(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(ConfigFileFormat.analyFormat("sds.xml"));
        System.out.println(ConfigFileFormat.clearFormat("sds.xml"));
    }

    static {
        SUPPORT_FORMATS = Maps.newLinkedHashMap();
        for (ConfigFileFormat format : ConfigFileFormat.values()) {
            SUPPORT_FORMATS.put(format.value, format);
        }
    }
}

