/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.client.rocketmq;

import cn.com.duiba.apollo.client.rocketmq.ApolloClientRocketmqProperties;
import cn.com.duiba.apollo.client.rocketmq.ApolloEventProducer;
import cn.com.duiba.apollo.client.rocketmq.ConfigServerEventListener;
import cn.com.duiba.apollo.client.rocketmq.RocketMQListenerBindingContainer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={ApolloClientRocketmqProperties.class})
public class ApolloClientRocketmqConfiguration {
    @Bean
    public ConfigServerEventListener configServerEventListener() {
        return new ConfigServerEventListener();
    }

    @Bean(initMethod="start", destroyMethod="shutdown")
    public DefaultMQProducer apolloMQProducer(Environment environment, ApolloClientRocketmqProperties apolloClientRocketmqProperties) throws MQClientException {
        String group = environment.getProperty("spring.application.name");
        DefaultMQProducer rocketMqProducer = new DefaultMQProducer(group);
        rocketMqProducer.setNamesrvAddr(apolloClientRocketmqProperties.getNameServer());
        rocketMqProducer.setSendMsgTimeout(3000);
        rocketMqProducer.setMaxMessageSize(4096);
        return rocketMqProducer;
    }

    @Bean(initMethod="init", destroyMethod="destroy")
    public RocketMQListenerBindingContainer rocketMQListenerBindingContainer() {
        return new RocketMQListenerBindingContainer();
    }

    @Bean
    public ApolloEventProducer apolloEventProducer() {
        return new ApolloEventProducer();
    }
}

