package cn.com.duiba.apollo.client.utils;

import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PasswordUtils {

    private static final String KEY = "CNxgrtFG2nYQUfu";

    private static final String PASSWORD_PREFIX = "dbseccode";

    private static final String PASSWORD_REPLACE = "****************";

    private static final Pattern pattern = Pattern.compile("^\\*+$");

    public static boolean isAbortiveValue(String value){
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public static String encryptValue(String value) {
        if(StringUtils.isBlank(value)){
            return "";
        }
        if(StringUtils.startsWith(value,PASSWORD_PREFIX)){
            return value;
        }
        return PASSWORD_PREFIX+ BlowfishUtils.encryptBlowfish(value,KEY);
    }

    public static String decryptValue(String value){
        if(!isPassword(value)){
            return value;
        }
        String source = value.substring(PASSWORD_PREFIX.length());
        return BlowfishUtils.decryptBlowfish(source, KEY);
    }

    public static boolean isPassword(String value){
        if(StringUtils.isBlank(value)){
            return false;
        }
        return StringUtils.startsWithIgnoreCase(value,PASSWORD_PREFIX);
    }

    public static String encryptView(String value){
        if(isPassword(value)){
            return PASSWORD_REPLACE;
        }
        return value;
    }

}
