/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.client.service.resource;

import cn.com.duiba.apollo.client.dto.ReferenceReleaseDTO;
import cn.com.duiba.apollo.client.event.InstanceReferenceEvent;
import cn.com.duiba.apollo.client.remoteservice.RemoteResourceReferenceService;
import cn.com.duiba.apollo.client.service.ApolloAccessTokenService;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duibaboot.ext.autoconfigure.monitor.cache.CacheMonitorExclude;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

public class ResourceReferenceClientService {
    private static final Logger log = LoggerFactory.getLogger(ResourceReferenceClientService.class);
    @Resource
    private RemoteResourceReferenceService remoteResourceReferenceService;
    @Resource
    private ApolloAccessTokenService apolloAccessTokenService;
    @CacheMonitorExclude
    private LoadingCache<Long, ReferenceReleaseDTO> cache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, ReferenceReleaseDTO>(){

        public ReferenceReleaseDTO load(@Nonnull Long referenceId) {
            String accessToken = ResourceReferenceClientService.this.apolloAccessTokenService.getAccessToken();
            try {
                return ResourceReferenceClientService.this.remoteResourceReferenceService.findReferencePublishItems(accessToken, referenceId);
            }
            catch (BizException e) {
                log.error("\u52a0\u8f7d\u8d44\u6e90\u5b9e\u4f8b\u914d\u7f6e\u5931\u8d25", (Throwable)e);
                return new ReferenceReleaseDTO();
            }
        }
    });

    @Order(value=-2147483648)
    @EventListener(value={InstanceReferenceEvent.class})
    public void instanceReferenceEventListener(InstanceReferenceEvent event) {
        this.cache.invalidate((Object)event.getReferenceId());
    }

    public ReferenceReleaseDTO findReferenceProperties(Long referenceId) {
        return (ReferenceReleaseDTO)Objects.requireNonNull(this.cache.get((Object)referenceId));
    }
}

