/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.client.service.rocketmq;

import cn.com.duiba.apollo.client.event.InstanceReferenceEvent;
import cn.com.duiba.apollo.client.event.NamespaceReleaseEvent;
import cn.com.duiba.apollo.client.service.ApolloAccessTokenService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ConfigServerEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConfigServerEventListener.class);
    private static final Map<String, Class<?>> EVENT_CLASS_MAP = Maps.newConcurrentMap();
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ApolloAccessTokenService apolloAccessTokenService;

    void onMessage(MessageExt messageExt) {
        InstanceReferenceEvent referenceEvent;
        String className = messageExt.getUserProperty("CONFIG_SERVER_EVENT_CLASS");
        if (StringUtils.isBlank((CharSequence)className)) {
            return;
        }
        Class<?> eventClass = EVENT_CLASS_MAP.get(className);
        if (Objects.isNull(eventClass)) {
            return;
        }
        String json = new String(messageExt.getBody(), StandardCharsets.UTF_8);
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        Object event = jsonObject.toJavaObject(eventClass);
        if (event instanceof InstanceReferenceEvent && !Objects.equals((referenceEvent = (InstanceReferenceEvent)event).getUserId(), this.apolloAccessTokenService.getSceneId())) {
            return;
        }
        this.applicationContext.publishEvent(event);
    }

    private static void regestEventClass(Class<?> eventClass) {
        EVENT_CLASS_MAP.put(eventClass.getName(), eventClass);
    }

    static {
        ConfigServerEventListener.regestEventClass(InstanceReferenceEvent.class);
        ConfigServerEventListener.regestEventClass(NamespaceReleaseEvent.class);
    }
}

