package cn.com.duiba.apollo.client.remoteservice;

import cn.com.duiba.apollo.client.dto.KeyValueDTO;
import cn.com.duiba.apollo.client.dto.ReferenceReleaseDTO;
import cn.com.duiba.apollo.client.dto.ReferenceViewDTO;
import cn.com.duiba.apollo.client.dto.ResourceReferenceDTO;
import cn.com.duiba.apollo.client.params.PublishReferenceParams;
import cn.com.duiba.apollo.client.params.StartReferenceParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteResourceReferenceService {

    /**
     * 获取一个引用
     */
    ResourceReferenceDTO findResourceReference(String accessToken, Long referenceId) throws BizException;

    /**
     * 获取一个引用
     */
    ResourceReferenceDTO findReferenceByBizIdAndInstanceId(String accessToken,String bizId,Long instanceId) throws BizException;

    /**
     * 获取一个业务id下所有的实例引用
     * @param accessToken 访问凭证
     * @param bizId 业务id
     * @return 资源引用
     **/
    List<ResourceReferenceDTO> findResourceReferenceByBizId(String accessToken,String bizId) throws BizException;

    /**
     * 申请资源(添加资源引用)
     * 在申请时指定 instanceAlias 或者 templateId，资源在授权之后会自动启用
     * @param accessToken 访问凭证
     * @param reference 引用
     **/
    void applyResourceInstance(String accessToken,ResourceReferenceDTO reference) throws BizException;

    /**
     * 删除资源引用
     * @param accessToken 访问凭证
     * @param referenceId 引用id
     */
    void removeResourceReference(String accessToken,Long operator,Long referenceId) throws BizException;

    /**
     * 启用（编辑）资源，当模板发生变更时，会清除所有的覆盖配置
     * @param accessToken 访问凭证
     * @param params 参数
     **/
    void startReference(String accessToken,Long referenceId,StartReferenceParams params) throws BizException;

    /**
     * 停用资源 （发布事件）
     * @param accessToken 访问凭证
     * @param referenceId 引用id
     */
    void stopReference(String accessToken,Long referenceId) throws BizException;

    /**
     * 覆写引用配置
     * @param accessToken 访问配置
     * @param operator 修改人
     * @param referenceId 引用id
     * @param kv 覆写配置的内容
     */
    void overrideReferenceItem(String accessToken,Long operator,Long referenceId,KeyValueDTO kv) throws BizException;

    /**
     * 移除引用的覆盖配置
     * @param accessToken 访问配置
     * @param operator 修改人
     * @param referenceId 引用id
     * @param key 需要删除的item的键
     */
    void removeReferenceItem(String accessToken,Long operator,Long referenceId,String key) throws BizException;

    /**
     * 提取配置
     * @param accessToken 访问凭证
     * @param referenceId 引用id
     * @return 发布的版本配置
     */
    ReferenceReleaseDTO findReferencePublishItems(String accessToken, Long referenceId) throws BizException;

    /**
     * 发布引用配置
     * @param accessToken 访问凭证
     * @param params 发布的参数
     */
    void publishReference(String accessToken,PublishReferenceParams params) throws BizException;

    /**
     * 发布引用配置
     * @param accessToken 访问凭证
     * @param referenceId 引用id
     */
    ReferenceViewDTO findReferenceView(String accessToken, Long referenceId) throws BizException;


}
