package cn.com.duiba.apollo.client.remoteservice;

import cn.com.duiba.apollo.client.dto.ResourceTemplateDTO;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteResourceTemplateService {

    /**
     * 获取一个类型下所有的模板
     * @param typeId 资源类型id
     * @return 资源模板
     */
    List<ResourceTemplateDTO> findAllTemplateByTypeId(Long typeId);

    /**
     * 批量获取模板
     * @param ids 模板ids
     * @return 模板列表
     */
    List<ResourceTemplateDTO> findAllTemplateByIds(List<Long> ids);


}
