package cn.com.duiba.apollo.client.service.rocketmq;

import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

/**
 * @author liuyao
 */
@Configuration
@EnableConfigurationProperties(ApolloClientRocketmqProperties.class)
public class ApolloClientRocketmqConfiguration {

    @Bean
    public ConfigServerEventListener configServerEventListener(){
        return new ConfigServerEventListener();
    }

    @Bean(initMethod = "start",destroyMethod = "shutdown")
    public DefaultMQProducer apolloMqProducer(Environment environment,ApolloClientRocketmqProperties apolloClientRocketmqProperties) throws MQClientException {
        String group = environment.getProperty("spring.application.name");
        DefaultMQProducer rocketMqProducer = new DefaultMQProducer(group);
        rocketMqProducer.setNamesrvAddr(apolloClientRocketmqProperties.getNameServer());
        rocketMqProducer.setSendMsgTimeout(3000);
        rocketMqProducer.setMaxMessageSize(1024 * 4);
        return rocketMqProducer;
    }

    @Bean(initMethod = "init",destroyMethod = "destroy")
    public RocketMQListenerBindingContainer rocketMqListenerBindingContainer(){
        return new RocketMQListenerBindingContainer();
    }

    @Bean
    public ApolloEventProducer apolloEventProducer(){
        return new ApolloEventProducer();
    }

}
