
package cn.com.duiba.apollo.client.service.rocketmq;

import cn.com.duiba.apollo.client.event.InstanceReferenceEvent;
import cn.com.duiba.apollo.client.event.NamespaceReleaseEvent;
import cn.com.duiba.apollo.client.service.ApolloAccessTokenService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

/**
 *
 */
@Slf4j
public class ConfigServerEventListener {

    private static final Map<String,Class<?>> EVENT_CLASS_MAP = Maps.newConcurrentMap();
    static {
        regestEventClass(InstanceReferenceEvent.class);
        regestEventClass(NamespaceReleaseEvent.class);
    }

    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ApolloAccessTokenService apolloAccessTokenService;

    void onMessage(MessageExt messageExt){
        String className = messageExt.getUserProperty(MessageHead.CONFIG_SERVER_EVENT_CLASS);
        if(StringUtils.isBlank(className)){
            return;
        }
        Class<?> eventClass = EVENT_CLASS_MAP.get(className);
        if(Objects.isNull(eventClass)){
            return;
        }
        String json = new String(messageExt.getBody(), StandardCharsets.UTF_8);
        JSONObject jsonObject = JSONObject.parseObject(json);
        Object event = jsonObject.toJavaObject(eventClass);

        if(event instanceof InstanceReferenceEvent){
            InstanceReferenceEvent referenceEvent = (InstanceReferenceEvent)event;
            if(!Objects.equals(referenceEvent.getUserId(),apolloAccessTokenService.getSceneId())){
                return;
            }
        }
        applicationContext.publishEvent(event);
    }

    private static void regestEventClass(Class<?> eventClass){
        EVENT_CLASS_MAP.put(eventClass.getName(),eventClass);
    }

}
