package cn.com.duiba.apollo.client;

import cn.com.duiba.apollo.client.service.ApolloAccessTokenService;
import cn.com.duiba.apollo.client.service.resource.ResourceReferenceClientService;
import cn.com.duiba.apollo.client.service.stream.ApolloClientStreamConfiguration;
import cn.com.duiba.apollo.client.service.stream.ApolloMessageConverter;
import cn.com.duibaboot.ext.stream.annotation.StreamMessageConverter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author liuyao
 */
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableScheduling
@Configuration
@Import({
        ApolloClientStreamConfiguration.class,
})
@EnableConfigurationProperties(ApolloClientProperties.class)
public class ApolloClientConfiguration {

    @Bean
    public ApolloAccessTokenService apolloAccessTokenService(){
        return new ApolloAccessTokenService();
    }

    @Bean
    public ResourceReferenceClientService resourceReferenceClientService(){
        return new ResourceReferenceClientService();
    }

    @Bean
    @StreamMessageConverter
    public ApolloMessageConverter apolloMessageConverter(){
        return new ApolloMessageConverter();
    }

}
