package cn.com.duiba.apollo.client;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;

/**
 * @author liuyao
 */
@Data
@ConfigurationProperties(prefix = "apollo.client")
public class ApolloClientProperties implements Serializable {

    private String accessKey;

    private String accessSecret;

    public boolean isStartResourceApi(){
        return StringUtils.isNotBlank(accessKey) && StringUtils.isNotBlank(accessSecret);
    }


}
