/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.apollo.client.utils;

import cn.com.duiba.apollo.client.exception.BeanUtilsException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.CollectionUtils;

public class BeanUtils {
    private static final String[] COPY_IGNORED_PROPERTIES = new String[]{"id", "dataChangeCreatedBy", "dataChangeCreatedTime", "dataChangeLastModifiedTime"};

    public static <T> List<T> batchTransform(Class<T> clazz, List<? extends Object> srcList) {
        if (CollectionUtils.isEmpty(srcList)) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(srcList.size());
        for (Object object : srcList) {
            result.add(BeanUtils.transfrom(clazz, object));
        }
        return result;
    }

    public static <T> T transfrom(Class<T> clazz, Object src) {
        if (src == null) {
            return null;
        }
        T instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            throw new BeanUtilsException(e);
        }
        org.springframework.beans.BeanUtils.copyProperties((Object)src, instance, (String[])BeanUtils.getNullPropertyNames(src));
        return instance;
    }

    private static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static <K, V> Map<K, V> mapByKey(String key, List<? extends Object> list) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (CollectionUtils.isEmpty(list)) {
            return map;
        }
        try {
            Class<?> clazz = list.get(0).getClass();
            Field field = BeanUtils.deepFindField(clazz, key);
            if (field == null) {
                throw new IllegalArgumentException("Could not find the key");
            }
            field.setAccessible(true);
            for (Object object : list) {
                map.put(field.get(object), object);
            }
        }
        catch (Exception e) {
            throw new BeanUtilsException(e);
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> aggByKeyToList(String key, List<? extends Object> list) {
        HashMap<Object, List> map = new HashMap<Object, List>();
        if (CollectionUtils.isEmpty(list)) {
            return map;
        }
        try {
            Class<?> clazz = list.get(0).getClass();
            Field field = BeanUtils.deepFindField(clazz, key);
            if (field == null) {
                throw new IllegalArgumentException("Could not find the key");
            }
            field.setAccessible(true);
            for (Object object : list) {
                Object k = field.get(object);
                map.computeIfAbsent(k, k1 -> new ArrayList());
                ((List)map.get(k)).add(object);
            }
        }
        catch (Exception e) {
            throw new BeanUtilsException(e);
        }
        return map;
    }

    public static <K> Set<K> toPropertySet(String key, List<? extends Object> list) {
        HashSet<Object> set = new HashSet<Object>();
        if (CollectionUtils.isEmpty(list)) {
            return set;
        }
        try {
            Class<?> clazz = list.get(0).getClass();
            Field field = BeanUtils.deepFindField(clazz, key);
            if (field == null) {
                throw new IllegalArgumentException("Could not find the key");
            }
            field.setAccessible(true);
            for (Object object : list) {
                set.add(field.get(object));
            }
        }
        catch (Exception e) {
            throw new BeanUtilsException(e);
        }
        return set;
    }

    private static Field deepFindField(Class<? extends Object> clazz, String key) {
        Field field = null;
        while (!clazz.getName().equals(Object.class.getName())) {
            try {
                field = clazz.getDeclaredField(key);
                if (field == null) continue;
                break;
            }
            catch (Exception e) {
                clazz = clazz.getSuperclass();
            }
        }
        return field;
    }

    public static Object getProperty(Object obj, String fieldName) {
        try {
            Field field = BeanUtils.deepFindField(obj.getClass(), fieldName);
            if (field != null) {
                field.setAccessible(true);
                return field.get(obj);
            }
        }
        catch (Exception e) {
            throw new BeanUtilsException(e);
        }
        return null;
    }

    public static void setProperty(Object obj, String fieldName, Object value) {
        try {
            Field field = BeanUtils.deepFindField(obj.getClass(), fieldName);
            if (field != null) {
                field.setAccessible(true);
                field.set(obj, value);
            }
        }
        catch (Exception e) {
            throw new BeanUtilsException(e);
        }
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
    }

    public static void copyEntityProperties(Object source, Object target) {
        org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target, (String[])COPY_IGNORED_PROPERTIES);
    }
}

