define([
    "angular",
    "/apollo/js/apollo-common.js",
    "/apollo/js/apollo-resource-service.js",
    "/apollo/js/apollo-resource-directive.js",
    "less!/apollo/config.less",
], function (angular) {

    const apollo = angular.module("apollo.configuration",[
        "apollo.ui.common",
        "apollo.resource.service",
        "apollo.resource.directive"
    ]);

    apollo.service("ApolloService",ApolloService);

    const TABLE_VIEW_OPER_TYPE = {
        CREATE: 'create',
        UPDATE: 'update'
    };

    function ApolloService($uibModal,ApolloResourceService,$q){
        /**
         * params{
         *      key:键值
         *      value:值
         *      comment:描述
         *      needSelectCluster:是否需要进行集群选择
         * }
         */
        function create(params){
            params.tableViewOperType = TABLE_VIEW_OPER_TYPE.CREATE;
            if(!!params.key){
                params.cover = true;
            }
            return openItemModel(params);
        }

        /**
         * params{
         *      key:键值
         *      value:值
         *      comment:描述
         *      needSelectCluster:是否需要进行集群选择
         * }
         */
        function edit(params) {
            params.tableViewOperType = TABLE_VIEW_OPER_TYPE.UPDATE;
            return openItemModel(params);
        }

        function openItemModel(params){
            const instance = $uibModal.open({
                size: "lg",
                animation: true,
                templateUrl: '/apollo/model/item-modal.html',
                controller: "ItemKeyValueModelController",
                backdrop: "static",
                resolve:{
                    item:function(){
                        return angular.copy(params);
                    },
                }
            });
            return instance.result;
        }

        function showText(text){
            $uibModal.open({
                size: "lg",
                animation: true,
                templateUrl: '/apollo/model/show-text-modal.html',
                controller: "ShowTextModalController",
                backdrop: true,
                resolve: {
                    text: function () {
                        return text;
                    }
                }
            });
        }

        function selectApolloInstance(supportTypes,title){
            const instance = $uibModal.open({
                size: 'lg',
                animation: true,
                templateUrl: '/apollo/model/apollo-select-instances.html',
                controller: 'ApolloInstancesModelController',
                backdrop: 'static',
                resolve:{
                    modelParams:function(){
                        return {
                            types:supportTypes,
                            title:title
                        }
                    }
                }
            });
            return instance.result;
        }

        function preview(instanceId,templateId,instanceAlias){
            $uibModal.open({
                size: "full",
                animation: true,
                templateUrl: '/apollo/model/template-preview.html',
                controller: "ApolloResourceTemplatePreviewController",
                backdrop: true,
                resolve:{
                    params:function(){
                        return {
                            instanceId:instanceId,
                            templateId:templateId,
                            instanceAlias
                        }
                    },
                }
            });
        }

        function applyResourceInstance(bizId){
            const defer = $q.defer();
            selectApolloInstance(new Set(),"选择资源").then(function (instance) {
                ApolloResourceService.applyResourceInstance(bizId,instance.id).then(function (result) {
                    defer.resolve(result);
                }, function (result) {
                    defer.reject(result);
                });
            })
            return defer.promise;
        }

        function openPreViewItemsModel(items){
            const instance = $uibModal.open({
                size: "full",
                animation: true,
                templateUrl: '/apollo/model/pre-view-items.html',
                controller: "PreViewItemsController",
                backdrop: 'static',
                resolve:{
                    items:function () {
                        return items;
                    },
                }
            });
            return instance.result;
        }

        return {
            create,
            edit,
            showText,
            selectApolloInstance,
            applyResourceInstance,
            preview,
            openPreViewItemsModel
        }
    }

});