/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.environment;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.EnvironmentService;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class ApplicationBootEnvironmentConfiguration {
    @Bean
    public Environment currentEnvironment(org.springframework.core.env.Environment environment) {
        String[] profileArray;
        String profiles = environment.getProperty("spring.profiles.active", Environment.DEV.getEnvId());
        for (String profile : profileArray = StringUtils.commaDelimitedListToStringArray((String)profiles)) {
            Environment current = Environment.getEnvByPrefix(profile);
            if (!Objects.nonNull(current)) continue;
            return current;
        }
        return Environment.DEV;
    }

    @Bean
    @ConditionalOnMissingBean(value={RequestEnvironmentDecisionMaker.class})
    public RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker() {
        return new RequestEnvironmentDecisionMaker();
    }

    @Bean
    public EnvironmentService environmentService() {
        return new EnvironmentService();
    }
}

