package cn.com.duiba.application.boot.api.component.environment;


import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.domain.dto.ClusterDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteClusterService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Objects;

@Configuration
@Import(ApplicationProperties.class)
public class ApplicationBootEnvironmentConfiguration {

    @Resource
    private ApplicationProperties applicationProperties;

    /**
     * 当前物理机部署的环境
     */
    @Bean
    public Environment currentEnvironment(org.springframework.core.env.Environment environment){

        Environment environmentForConfig = applicationProperties.getEnvironment();
        if(environmentForConfig!=null){
            return environmentForConfig;
        }

        String profiles = environment.getProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY,Environment.DEV.getEnvId());

        String[] profileArray = StringUtils.commaDelimitedListToStringArray(profiles);

        for(String profile:profileArray){
            Environment current = Environment.getEnvByPrefix(profile);
            if(Objects.nonNull(current)){
                return current;
            }
        }
        return Environment.DEV;
    }


    @Bean
    @ConditionalOnMissingBean(RequestEnvironmentDecisionMaker.class)//允许用户自定义环境决定者行为
    public RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker(){
        return new RequestEnvironmentDecisionMaker();
    }

    @Bean
    public EnvironmentService environmentService(){
        return new EnvironmentService();
    }



}
