package cn.com.duiba.application.boot.api.component.environment;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

@Getter
public enum Environment implements Serializable {

    DEV(1L,"dev","开发环境"),
    TEST(2L,"test","测试环境"),
    PRE(4L,"pre","预发环境"),
    PROD(3L,"prod","生产环境");

    private final Long id;
    private final String envId;
    private final String envName;

    Environment(Long id,String envId,String envName){
        this.id = id;
        this.envId = envId;
        this.envName = envName;
    }

    public static Environment getEnvByEnvId(String envId){
        Objects.requireNonNull(envId);
        switch (envId){
            case "dev":return DEV;
            case "test":return TEST;
            case "pre":return PRE;
            case "prod":return PROD;
            default:return PROD;
        }
    }

    public static Environment getEnvById(Long id){
        switch (id.intValue()){
            case 1:return DEV;
            case 2:return TEST;
            case 3:return PROD;
            default:return PROD;
        }
    }

    public static Environment getEnvByPrefix(String prefix){
        for(Environment env: values()){
            if(StringUtils.startsWith(prefix,env.getEnvId())){
                return env;
            }
        }
        return null;
    }

    public static Boolean isOnline(Environment environment){
        return Objects.equals(environment,PROD) || Objects.equals(environment,PRE);
    }

    public static Environment parseEnvironmentEnum(String profiles){
        if(StringUtils.isBlank(profiles)){
            return PROD;
        }
        for(Environment environment: values()){
            if(StringUtils.startsWith(profiles,environment.getEnvId())){
                return environment;
            }
        }
        return PROD;
    }


}
