package cn.com.duiba.application.boot.api.component.environment;

import cn.com.duiba.application.boot.api.domain.dto.ClusterDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteClusterService;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.util.StringUtils;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

public class EnvironmentService {

    private static final String CLUSTER_PREFIX = "cluster#";
    public static final String DEFAULT_CLUSTER_KEY = "default";

    @Resource
    private RemoteClusterService remoteClusterService;
    @Resource
    private Environment currentEnvironment;
    @Resource
    private org.springframework.core.env.Environment environment;

    private String clusterKey = DEFAULT_CLUSTER_KEY;

    @PostConstruct
    public void init(){
        String profiles = environment.getProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY,Environment.DEV.getEnvId());
        String[] profileArray = StringUtils.commaDelimitedListToStringArray(profiles);

        clusterKey = DEFAULT_CLUSTER_KEY;
        for(String profile:profileArray){
            if(StringUtils.startsWithIgnoreCase(profile,CLUSTER_PREFIX)){
                clusterKey = profile.replace(CLUSTER_PREFIX,"");
            }
        }
    }

    public ClusterDto currentCluster(){
        return remoteClusterService.findByUK(currentEnvironment,clusterKey);
    }

    public String currentClusterKey(){
        return clusterKey;
    }



}
