package cn.com.duiba.application.boot.api.component.oauth2;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.mappingmode.MappingModeProperties;
import cn.com.duiba.application.boot.api.domain.model.OauthInfo;
import cn.com.duiba.application.boot.api.domain.model.OauthToken;
import cn.com.duiba.application.boot.api.domain.model.OauthTokenRequest;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Optional;

@Slf4j
public class ApplicationBootOauth2ClientForApi extends ApplicationBootOauth2Client {


    @CanAccessInsideNetwork
    @Resource
    public RestTemplate oauthRestTemplate;
    @Resource
    public MappingModeProperties mappingModeProperties;
    @Resource
    private ApplicationBootOauthProperties applicationBootOauthProperties;
    @Resource
    private ApplicationProperties applicationProperties;
    @Resource
    private Environment currentEnvironment;

    @Override
    public String loadOauthToken() {
        OauthTokenRequest request = new OauthTokenRequest();
        request.setAppAlias(applicationProperties.getName());
        request.setAppSecret(applicationProperties.getSecret());
        request.setEnvironment(currentEnvironment.getEnvId());
        request.setState(getState());

        OauthToken token = oauthRestTemplate.postForObject(buildHost("/oauth/getAccessToken"),request,OauthToken.class);
        if(StringUtils.isBlank(token.getAccessToken())){
            throw new RuntimeException("获取accessToken失败");
        }
        if(!StringUtils.equals(getState(),token.getState())){
            throw new RuntimeException("获取accessToken验证失败");
        }
        return token.getAccessToken();
    }

    @Override
    public OauthInfo loadOauthInfo(String accessToken) {
        return oauthRestTemplate.getForObject(buildHost("/oauth/authorize")+"?accessToken="+accessToken,OauthInfo.class);
    }

    private String buildHost(String path){
        String host = Optional.ofNullable(applicationBootOauthProperties.getHost()).orElse("http://"+mappingModeProperties.getMappingMode().get("application-boot"));
        if(StringUtils.isBlank(host) && StringUtils.equals("application-boot",applicationProperties.getName())){
            host = "http://localhost:9999";
        }
        return host + path;
    }

}
