package cn.com.duiba.application.boot.api.remoteservice;

import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteApplicationService {

    /**
     * 创建应用
     **/
    void createApplication(ApplicationDto app) throws BizException;

    /**
     * 更新应用
     **/
    void updateApplication(ApplicationDto app) throws BizException;
    /**
     * 根据系统别名获取系统信息
     * @param appAlias 系统别名
     * @return 应用配置
     */
    ApplicationDto getApplicationByAlias(String appAlias);

    List<ApplicationDto> findAllApplication();

}
