/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duiba.application.boot.api.component.mappingmode.MappingModeProperties;
import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class MappingModeEnvApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final String RIBBON_CONFIG_SUFFIX = ".ribbon.listOfServers";

    public void initialize(ConfigurableApplicationContext application) {
        ConfigurableEnvironment environment = application.getEnvironment();
        String appName = environment.getProperty("spring.application.name");
        PropertyResolver resolver = new PropertyResolver((AbstractEnvironment)environment, "application.boot");
        MappingModeProperties properties = new MappingModeProperties();
        resolver.bindToConfig((Object)properties);
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, String> entry : properties.getMappingMode().entrySet()) {
            if (StringUtils.equals((String)entry.getKey(), (String)appName)) continue;
            map.put(entry.getKey() + RIBBON_CONFIG_SUFFIX, entry.getValue());
        }
        MapPropertySource propertySource = new MapPropertySource("application.boot.mapping.mode", (Map)map);
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst((PropertySource)propertySource);
    }

    public int getOrder() {
        return -2147483628;
    }
}

