/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauth2Client;
import cn.com.duiba.application.boot.api.domain.model.OauthInfo;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MappingModeServerInterceptor
extends HandlerInterceptorAdapter {
    public static final String APP_BOOT_MAPPING_MODE = "APP_BOOT_MAPPING_MODE";
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;
    @Resource
    private ApplicationBootOauth2Client applicationBootOauth2Client;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!"true".equals(request.getHeader("X-Rpc"))) {
            return true;
        }
        if (HttpRequestUtils.isLanRequest((HttpServletRequest)request)) {
            return true;
        }
        PerfTestContext._setPerfTestMode((Boolean)false);
        String accessToken = request.getHeader("X-MAPPING-MODE-AUTH");
        String state = request.getHeader("X-MAPPING-MODE-STATE");
        if (StringUtils.isBlank((String)accessToken)) {
            return false;
        }
        OauthInfo oauthInfo = this.applicationBootOauth2Client.getOauthInfo(accessToken);
        if (!StringUtils.equals((String)oauthInfo.getState(), (String)state)) {
            throw new BizException("\u9a8c\u8bc1\u5931\u8d25(100)");
        }
        request.setAttribute(APP_BOOT_MAPPING_MODE, (Object)true);
        Environment environment = Environment.getEnvByEnvId(oauthInfo.getEnvironment());
        this.requestEnvironmentDecisionMaker.$$SetEnvironment(environment);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.requestEnvironmentDecisionMaker.$$Clear();
    }
}

