package cn.com.duiba.application.boot.api.component.environment;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

@Getter
public enum Environment implements Serializable {

    DEV("dev","开发环境",1),
    TEST("test","测试环境",2),
    PRE("pre","预发环境",3),
    PROD("prod","生产环境",4);

    private final String envId;
    private final String envName;

    private final Integer weight;

    Environment(String envId,String envName,Integer weight){
        this.envId = envId;
        this.envName = envName;
        this.weight = weight;
    }

    public static Environment getEnvByEnvId(String envId){
        Objects.requireNonNull(envId);
        switch (envId){
            case "dev":return DEV;
            case "test":return TEST;
            case "pre":return PRE;
            case "prod":return PROD;
            default:return PROD;
        }
    }

    public static Environment getEnvByPrefix(String prefix){
        for(Environment env: values()){
            if(StringUtils.startsWith(prefix,env.getEnvId())){
                return env;
            }
        }
        return null;
    }

    public static Boolean isOnline(Environment environment){
        return Objects.equals(environment,PROD) || Objects.equals(environment,PRE);
    }

    public static Environment parseEnvironmentEnum(String profiles){
        if(StringUtils.isBlank(profiles)){
            return PROD;
        }
        for(Environment environment: values()){
            if(StringUtils.startsWith(profiles,environment.getEnvId())){
                return environment;
            }
        }
        return PROD;
    }

}
