package cn.com.duiba.application.boot.api.component.mappingmode;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(MappingModeProperties.class)
public class MappingModeConfiguration {

    @Bean
    public MappingModePlugin mappingModePlugin(){
        return new MappingModePlugin();
    }

    @Bean
    @ConditionalOnClass(Tracer.class)
    public MappingModeSleathPlugin mappingModeSleathPlugin(){
        return new MappingModeSleathPlugin();
    }

}
