package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.annotation.Order;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.Map;

@Aspect
@Order(2)
public class MappingModeSleathPlugin implements RequestInterceptor {

    @Resource
    private Tracer tracer;

    @Override
    public void apply(RequestTemplate template) {

        Map<String, Collection<String>> headers = template.headers();
        if(!headers.containsKey(MappingModePlugin.X_MAPPING_MODE_OAUTH2)){
            return;
        }
        template.header(Span.SPAN_FLAGS,Span.SPAN_NOT_SAMPLED);//断开调用链


        if(!tracer.isTracing() || !tracer.getCurrentSpan().isExportable()){
            return;
        }
        Span span = tracer.createSpan(RpcContext.getContext().getTargetServiceId() +":/"+RpcContext.getContext().getMethod());
        try {
            span.tag(Span.SPAN_LOCAL_COMPONENT_TAG_NAME, "app-boot-mappingmode");//本地组件名
            span.tag(Span.SPAN_PEER_SERVICE_TAG_NAME, template.method());//远程服务名
            span.logEvent(Span.CLIENT_SEND);

        } finally {
            span.logEvent(Span.CLIENT_RECV);
            this.tracer.close(span);
        }

    }


}
