package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.XssDefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.XssHttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;

public class MappingModeXssDefensivePolicy extends XssDefensivePolicy {

    @Override
    public HttpServletRequest preprocessorRequest(HttpServletRequest request) {
        String accessToken = request.getHeader(MappingModePlugin.X_MAPPING_MODE_OAUTH2);
        if(isFeignRequest(request)|| StringUtils.isNotBlank(accessToken)){
            return request;
        }else {
            return new XssHttpServletRequestWrapper(request);
        }
    }

}
