package cn.com.duiba.application.boot.api.component.oauth2;

import cn.com.duiba.application.boot.api.domain.model.OauthInfo;
import cn.com.duiba.application.boot.api.domain.model.OauthToken;
import cn.com.duiba.application.boot.api.domain.model.OauthTokenRequest;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.concurrent.TimeUnit;

@Slf4j
public abstract class ApplicationBootOauth2Client {

    private String state = UUIDUtils.createSecureUUID();

    private LoadingCache<String,String> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build(new CacheLoader<String, String>() {
        @Nullable
        @Override
        public String load(@Nonnull String s) {
            return loadOauthToken();
        }
    });

    private LoadingCache<String,OauthInfo> authInfocache = Caffeine.newBuilder().expireAfterWrite(1L,TimeUnit.HOURS).build(new CacheLoader<String, OauthInfo>() {
        @Nullable
        public OauthInfo load(@Nonnull String accessToken) throws Exception {
            return loadOauthInfo(accessToken);
        }
    });

    public String getAccessToken(){
        try {
            return cache.get("$$thisApplication");
        }catch (Exception e){
            log.error("获取AccessToken失败",e);
            return "";
        }
    }

    public OauthInfo getOauthInfo(String accessToken){
        return authInfocache.get(accessToken);
    }


    public abstract String loadOauthToken();

    public abstract OauthInfo loadOauthInfo(String accessToken);

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }
}
