/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.oauth2;

import cn.com.duiba.application.boot.api.domain.model.OauthInfo;
import cn.com.duiba.application.boot.api.domain.model.OauthToken;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationBootOauth2Client {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBootOauth2Client.class);
    private final String state = UUIDUtils.createSecureUUID();
    private volatile String accessToken;
    private final LoadingCache<String, OauthInfo> authInfoCache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, OauthInfo>(){

        @Nullable
        public OauthInfo load(@Nonnull String accessToken) {
            return ApplicationBootOauth2Client.this.loadOauthInfo(accessToken);
        }
    });

    public String getAccessToken() {
        OauthInfo oauthInfo;
        if (StringUtils.isBlank((String)this.accessToken)) {
            this.refreshAccessToken();
        }
        if (Objects.isNull(oauthInfo = (OauthInfo)this.authInfoCache.get((Object)this.accessToken)) || Objects.isNull(oauthInfo.getExpiration()) || new Date().after(oauthInfo.getExpiration())) {
            this.refreshAccessToken();
            this.authInfoCache.refresh((Object)this.accessToken);
        }
        return this.accessToken;
    }

    public OauthInfo getOauthInfo(String accessToken) {
        OauthInfo oauthInfo = (OauthInfo)this.authInfoCache.get((Object)accessToken);
        if (Objects.isNull(oauthInfo) || Objects.isNull(oauthInfo.getExpiration()) || new Date().after(oauthInfo.getExpiration())) {
            this.authInfoCache.refresh((Object)accessToken);
        }
        return (OauthInfo)this.authInfoCache.get((Object)accessToken);
    }

    public void refreshOauthInfoCache(String accessToken) {
        this.authInfoCache.refresh((Object)accessToken);
    }

    private synchronized void refreshAccessToken() {
        try {
            if (StringUtils.isBlank((String)this.accessToken)) {
                OauthToken oauthToken = this.loadOauthToken();
                this.accessToken = oauthToken.getAccessToken();
                return;
            }
            OauthInfo oauthInfo = this.loadOauthInfo(this.accessToken);
            if (Objects.isNull(oauthInfo) || Objects.isNull(oauthInfo.getExpiration()) || new Date().after(oauthInfo.getExpiration())) {
                OauthToken oauthToken = this.loadOauthToken();
                this.accessToken = oauthToken.getAccessToken();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6accessToken\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public abstract OauthToken loadOauthToken();

    public abstract OauthInfo loadOauthInfo(String var1);

    public String getState() {
        return this.state;
    }
}

