/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.application;

import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class ApplicationCacheService {
    private Cache<Long, ApplicationDto> applicationCacheForId = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private Cache<String, ApplicationDto> applicationCacheForAlias = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    @Around(value="execution(* cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService.findApplicationById(..))")
    public Object findApplicationById(ProceedingJoinPoint point) throws Throwable {
        Long appId = (Long)point.getArgs()[0];
        ApplicationDto application = (ApplicationDto)this.applicationCacheForId.getIfPresent((Object)appId);
        if (Objects.isNull(application) && Objects.nonNull(application = (ApplicationDto)point.proceed())) {
            this.applicationCacheForId.put((Object)appId, (Object)application);
        }
        return application;
    }

    @Around(value="execution(* cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService.getApplicationByAlias(..))")
    public Object getApplicationByAlias(ProceedingJoinPoint point) throws Throwable {
        String appAlias = (String)point.getArgs()[0];
        ApplicationDto application = (ApplicationDto)this.applicationCacheForAlias.getIfPresent((Object)appAlias);
        if (Objects.isNull(application) && Objects.nonNull(application = (ApplicationDto)point.proceed())) {
            this.applicationCacheForAlias.put((Object)appAlias, (Object)application);
        }
        return application;
    }
}

