/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.environment;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class EnvironmentService {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentService.class);
    private static final String CLUSTER_PREFIX = "cluster_";
    public static final String DEFAULT_CLUSTER_KEY = "default";
    @Resource
    private org.springframework.core.env.Environment environment;
    @Resource
    private Environment currentEnvironment;
    private String clusterKey = "default";

    @PostConstruct
    public void init() {
        log.info("\u5f53\u524d\u73af\u5883:" + this.currentEnvironment.getEnvName());
        String profiles = this.environment.getProperty("spring.profiles.active", Environment.DEV.getEnvId());
        String[] profileArray = StringUtils.commaDelimitedListToStringArray((String)profiles);
        this.clusterKey = DEFAULT_CLUSTER_KEY;
        for (String profile : profileArray) {
            if (StringUtils.startsWithIgnoreCase((String)profile, (String)CLUSTER_PREFIX)) {
                this.clusterKey = profile.replace(CLUSTER_PREFIX, "");
            }
            if (StringUtils.startsWithIgnoreCase((String)profile, (String)"dev")) {
                this.clusterKey = "dev";
            }
            if (!StringUtils.startsWithIgnoreCase((String)profile, (String)"pre")) continue;
            this.clusterKey = "pre";
        }
    }

    public String currentClusterKey() {
        return this.clusterKey;
    }

    public Environment getCurrentEnvironment() {
        return this.currentEnvironment;
    }
}

