/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duiba.application.boot.api.component.mappingmode.MappingModeProperties;
import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class MappingModeEnvApplicationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(MappingModeEnvApplicationInitializer.class);
    private static final String RIBBON_CONFIG_SUFFIX = ".ribbon.listOfServers";

    public void initialize(ConfigurableApplicationContext application) {
        ConfigurableEnvironment environment = application.getEnvironment();
        String appName = environment.getProperty("spring.application.name");
        PropertyResolver resolver = new PropertyResolver((Environment)environment, "application.boot");
        MappingModeProperties properties = (MappingModeProperties)resolver.bindToConfig(MappingModeProperties.class);
        if (!properties.isMappingModeEnable()) {
            return;
        }
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, String> entry : properties.getMappingMode().entrySet()) {
            if (StringUtils.equals((String)entry.getKey(), (String)appName)) continue;
            log.info("\u4f9d\u8d56\u5e94\u7528" + entry.getKey() + "\u6620\u5c04\u5230:" + entry.getValue());
            map.put(entry.getKey() + RIBBON_CONFIG_SUFFIX, entry.getValue());
        }
        MapPropertySource propertySource = new MapPropertySource("application.boot.mapping.mode", (Map)map);
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst((PropertySource)propertySource);
    }

    public int getOrder() {
        return -2147483628;
    }
}

