/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.stream.channel;

import cn.com.duiba.application.boot.stream.channel.ChannelFactoryBean;
import cn.com.duiba.application.boot.stream.channel.ChannelKey;
import cn.com.duiba.application.boot.stream.channel.ChannelType;
import cn.com.duiba.application.boot.stream.config.BindingProperties;
import cn.com.duiba.application.boot.stream.config.BindingServiceProperties;
import cn.com.duiba.application.boot.stream.config.ConsumerProperties;
import cn.com.duiba.application.boot.stream.config.ProducerProperties;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class ChannelBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private BindingServiceProperties bindingServiceProperties;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        Map<String, BindingProperties> bindingPropertiesMap = this.bindingServiceProperties.getBindings();
        for (String bindingName : bindingPropertiesMap.keySet()) {
            ConsumerProperties consumerProperties;
            BindingProperties bindingProperties = bindingPropertiesMap.get(bindingName);
            ProducerProperties producerProperties = bindingProperties.getProducer();
            if (producerProperties.getEnable().booleanValue()) {
                ChannelKey channelKey = new ChannelKey();
                channelKey.setBindingName(bindingName);
                channelKey.setChannelType(ChannelType.OUTPUT);
                this.registerChannelBeanDefinition(channelKey, registry);
            }
            if (!(consumerProperties = bindingProperties.getConsumer()).getEnable().booleanValue()) continue;
            ChannelKey channelKey = new ChannelKey();
            channelKey.setBindingName(bindingName);
            channelKey.setChannelType(ChannelType.INPUT);
            this.registerChannelBeanDefinition(channelKey, registry);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    private void registerChannelBeanDefinition(ChannelKey channelKey, BeanDefinitionRegistry registry) {
        String beanName = ChannelFactoryBean.getBeanNameByBindingName(channelKey);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ChannelFactoryBean.class);
        builder.addPropertyValue("channelKey", (Object)channelKey);
        builder.addPropertyReference("channelInterceptorBox", "channelInterceptorBox");
        registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
    }

    public void setEnvironment(Environment environment) {
        this.bindingServiceProperties = (BindingServiceProperties)Binder.get((Environment)environment).bind("spring.cloud.stream", BindingServiceProperties.class).orElseCreate(BindingServiceProperties.class);
    }
}

